/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import cc.tweaked.cobalt.internal.LegacyEnv;
import cc.tweaked.cobalt.internal.unwind.Pause;
import cc.tweaked.cobalt.internal.unwind.UnwindState;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L0O4;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L4O0;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.ProtectedCall;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.InputReader;
import org.squiddev.cobalt.compiler.LoadState;
import org.squiddev.cobalt.compiler.LuaC;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.function.Dispatch;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.RegisteredFunction;
import org.squiddev.cobalt.function.ResumableVarArgFunction;
import org.squiddev.cobalt.lib.BaseLib$Load$lambda$invoke$0;
import org.squiddev.cobalt.lib.BaseLib$lambda$inext$2;
import org.squiddev.cobalt.lib.BaseLib$lambda$loadStream$3;
import org.squiddev.cobalt.lib.BaseLib$lambda$pairs$1;
import org.squiddev.cobalt.lib.BaseLib$lambda$tostring$0;
import org.squiddev.cobalt.unwind.SuspendedTask;

public final class BaseLib {
    private static final LuaString FUNCTION_STR = ValueFactory.valueOf("function");
    private static final LuaString LOAD_MODE = ValueFactory.valueOf("bt");
    private static final LuaString ASSERTION_FAILED = ValueFactory.valueOf("assertion failed!");
    private LuaValue next;
    private LuaValue inext;

    private BaseLib() {
    }

    public static void add(LuaState state) {
        LuaTable env = state.globals();
        BaseLib self = new BaseLib();
        env.rawset("_G", (LuaValue)env);
        env.rawset("_VERSION", (LuaValue)ValueFactory.valueOf("Lua 5.2"));
        RegisteredFunction[] registeredFunctionArray = new RegisteredFunction[21];
        registeredFunctionArray[0] = RegisteredFunction.of("error", BaseLib::error);
        registeredFunctionArray[1] = RegisteredFunction.ofV("setfenv", BaseLib::setfenv);
        registeredFunctionArray[2] = RegisteredFunction.ofV("assert", BaseLib::assert_);
        registeredFunctionArray[3] = RegisteredFunction.of("getfenv", BaseLib::getfenv);
        registeredFunctionArray[4] = RegisteredFunction.ofV("getmetatable", BaseLib::getmetatable);
        registeredFunctionArray[5] = RegisteredFunction.ofS("loadstring", BaseLib::loadstring);
        registeredFunctionArray[6] = RegisteredFunction.ofV("select", BaseLib::select);
        registeredFunctionArray[7] = RegisteredFunction.ofV("type", BaseLib::type);
        registeredFunctionArray[8] = RegisteredFunction.ofV("rawequal", BaseLib::rawequal);
        registeredFunctionArray[9] = RegisteredFunction.ofV("rawget", BaseLib::rawget);
        registeredFunctionArray[10] = RegisteredFunction.ofV("rawset", BaseLib::rawset);
        registeredFunctionArray[11] = RegisteredFunction.ofV("setmetatable", BaseLib::setmetatable);
        registeredFunctionArray[12] = RegisteredFunction.ofS("tostring", BaseLib::tostring);
        registeredFunctionArray[13] = RegisteredFunction.ofV("tonumber", BaseLib::tonumber);
        registeredFunctionArray[14] = RegisteredFunction.ofS("pairs", self::pairs);
        registeredFunctionArray[15] = RegisteredFunction.ofV("ipairs", self::ipairs);
        registeredFunctionArray[16] = RegisteredFunction.of("rawlen", BaseLib::rawlen);
        registeredFunctionArray[17] = RegisteredFunction.ofV("next", BaseLib::next);
        registeredFunctionArray[18] = RegisteredFunction.ofFactory("pcall", PCall::new);
        registeredFunctionArray[19] = RegisteredFunction.ofFactory("xpcall", XpCall::new);
        registeredFunctionArray[20] = RegisteredFunction.ofFactory("load", Load::new);
        RegisteredFunction.bind(env, registeredFunctionArray);
        self.next = env.rawget("next");
        self.inext = RegisteredFunction.ofS("inext", BaseLib::inext).create();
    }

    private static LuaValue error(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        throw new LuaError(arg1.isNil() ? Constants.NIL : arg1, arg2.optInteger(1));
    }

    private static Varargs setfenv(LuaState state, Varargs args) throws LuaError {
        LuaTable t = args.arg(2).checkTable();
        LuaValue f = BaseLib.getfenvobj(state, args.arg(1), false);
        if (!LegacyEnv.setEnv(f, t)) {
            throw new LuaError("'setfenv' cannot change environment of given object");
        }
        return f;
    }

    private static LuaValue getfenvobj(LuaState state, LuaValue arg, boolean optional) throws LuaError {
        int level;
        if (arg instanceof LuaFunction) {
            return arg;
        }
        int n = level = optional ? arg.optInteger(1) : arg.checkInteger();
        if (level < 0) {
            throw ErrorFactory.argError(1, "level must be non-negative");
        }
        if (level == 0) {
            return state.getCurrentThread();
        }
        LuaFunction f = LuaThread.getCallstackFunction(state, level);
        if (f == null) {
            throw ErrorFactory.argError(1, "invalid level");
        }
        return f;
    }

    private static Varargs assert_(LuaState state, Varargs args) throws LuaError {
        if (args.first().toBoolean()) {
            return args;
        }
        args.checkValue(1);
        throw new LuaError(args.count() > 1 ? args.arg(2) : ASSERTION_FAILED);
    }

    private static LuaValue getfenv(LuaState state, LuaValue args) throws LuaError {
        LuaValue f = BaseLib.getfenvobj(state, args, true);
        LuaTable env = LegacyEnv.getEnv(f);
        return env == null ? state.globals() : env;
    }

    private static LuaValue getmetatable(LuaState state, Varargs args) throws LuaError {
        LuaTable mt = args.checkValue(1).getMetatable(state);
        return mt != null ? mt.rawget(Constants.METATABLE).optValue(mt) : Constants.NIL;
    }

    private static Varargs loadstring(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
        LuaString script = args.arg(1).checkLuaString();
        InputStream is = script.toInputStream();
        return BaseLib.loadStream(state, di, is, args.arg(2).optLuaString(script), null, state.globals());
    }

    private static Varargs select(LuaState state, Varargs args) throws LuaError {
        int n = args.count() - 1;
        if (args.first().equals(ValueFactory.valueOf("#"))) {
            return ValueFactory.valueOf(n);
        }
        int i = args.arg(1).checkInteger();
        if (i == 0 || i < -n) {
            throw ErrorFactory.argError(1, "index out of range");
        }
        return args.subargs(i < 0 ? n + i + 2 : i + 1);
    }

    private static LuaValue type(LuaState state, Varargs args) throws LuaError {
        return args.checkValue(1).luaTypeName();
    }

    private static LuaValue rawequal(LuaState state, Varargs args) throws LuaError {
        return ValueFactory.valueOf(args.checkValue(1).equals(args.checkValue(2)));
    }

    private static LuaValue rawget(LuaState state, Varargs args) throws LuaError {
        return args.arg(1).checkTable().rawget(args.checkValue(2));
    }

    private static LuaValue rawset(LuaState state, Varargs args) throws LuaError {
        LuaTable t = args.arg(1).checkTable();
        LuaValue k = args.checkValue(2);
        LuaValue v = args.checkValue(3);
        t.rawset(k, v);
        return t;
    }

    private static LuaValue setmetatable(LuaState state, Varargs args) throws LuaError {
        LuaTable mt;
        LuaValue t = args.first();
        LuaValue mtValue = args.checkValue(2);
        if (mtValue instanceof LuaTable) {
            LuaTable tbl;
            mt = tbl = (LuaTable)mtValue;
        } else if (mtValue.isNil()) {
            mt = null;
        } else {
            throw ErrorFactory.argError(mtValue, "nil or table");
        }
        LuaTable mt0 = t.getMetatable(state);
        if (mt0 != null && !mt0.rawget(Constants.METATABLE).isNil()) {
            throw new LuaError("cannot change a protected metatable");
        }
        t.setMetatable(state, mt);
        return t;
    }

    private static LuaValue tostring(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
        di.state = BaseLib$lambda$tostring$0.make(state, args);
        return ((Varargs)((BaseLib$lambda$tostring$0)di.state).call(null)).first();
    }

    private static LuaValue tonumber(LuaState state, Varargs args) throws LuaError {
        LuaValue arg1 = args.checkValue(1);
        int base = args.arg(2).optInteger(10);
        if (base == 10) {
            return arg1.toNumber();
        }
        if (base < 2 || base > 36) {
            throw ErrorFactory.argError(2, "base out of range");
        }
        return arg1.checkLuaString().toNumber(base);
    }

    private Varargs pairs(LuaState state, DebugFrame frame, Varargs args) throws LuaError, UnwindThrowable {
        LuaValue value = args.checkValue(1);
        LuaValue pairs2 = value.metatag(state, Constants.PAIRS);
        if (pairs2.isNil()) {
            return ValueFactory.varargsOf(this.next, value, (Varargs)Constants.NIL);
        }
        frame.state = BaseLib$lambda$pairs$1.make(state, pairs2, value);
        return (Varargs)((BaseLib$lambda$pairs$1)frame.state).call(null);
    }

    private Varargs ipairs(LuaState state, Varargs args) throws LuaError {
        return ValueFactory.varargsOf(this.inext, args.checkValue(1), (Varargs)Constants.ZERO);
    }

    private static LuaValue rawlen(LuaState state, LuaValue v) throws LuaError {
        return switch (v.type()) {
            case 5 -> ValueFactory.valueOf(v.checkTable().length());
            case 4 -> ValueFactory.valueOf(v.checkLuaString().length());
            default -> throw ErrorFactory.argError(1, "table or string expected");
        };
    }

    private static Varargs next(LuaState state, Varargs args) throws LuaError {
        return args.arg(1).checkTable().next(args.arg(2));
    }

    private static Varargs inext(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
        LuaTable tbl;
        LuaValue table = args.arg(1);
        int key = args.arg(2).checkInteger() + 1;
        if (table instanceof LuaTable && (tbl = (LuaTable)table).getMetatable(state) == null) {
            LuaValue v = tbl.rawget(key);
            return v.isNil() ? Constants.NIL : ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(key), (Varargs)v);
        }
        di.state = BaseLib$lambda$inext$2.make(state, table, key);
        return (Varargs)((BaseLib$lambda$inext$2)di.state).call(null);
    }

    private static Varargs loadStream(LuaState state, DebugFrame frame, InputStream is, LuaString chunkName, LuaString mode, LuaValue env) throws UnwindThrowable, LuaError {
        frame.state = BaseLib$lambda$loadStream$3.make(state, is, chunkName, mode, env);
        return (Varargs)((BaseLib$lambda$loadStream$3)frame.state).call(null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ Varargs lambda$loadStream$3(LuaState luaState, InputStream inputStream, LuaString luaString, LuaString luaString2, LuaValue luaValue, Object object) throws LuaError, Pause {
        Object object2;
        Object v4;
        Object v3;
        LuaC.InputStreamReader inputStreamReader;
        LuaState luaState2;
        LoadState.FunctionFactory functionFactory;
        if (object == null) {
            try {
                void mode;
                void chunkName;
                void is;
                LuaState state;
                functionFactory = state.compiler;
                luaState2 = state;
                inputStreamReader = new LuaC.InputStreamReader(state, (InputStream)is);
                v3 = chunkName;
                v4 = mode;
                object2 = null;
            }
            catch (CompileException e) {
                return ValueFactory.varargsOf(Constants.NIL, (Varargs)ValueFactory.valueOf(e.getMessage()));
            }
        } else {
            object = (UnwindState$L0O4)object;
            if (((UnwindState$L0O4)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            luaState = (LuaState)((UnwindState$L0O4)object).o0;
            luaValue = (LuaValue)((UnwindState$L0O4)object).o1;
            functionFactory = luaState.compiler;
            luaState2 = null;
            inputStreamReader = null;
            v3 = null;
            v4 = null;
            object2 = ((UnwindState)object).child;
        }
        try {
            void env;
            return functionFactory.load(LuaC.compile(luaState2, inputStreamReader, v3, v4, object2), (LuaValue)env);
        }
        catch (Pause pause) {
            object = UnwindState$L0O4.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L0O4)object).o0 = luaState;
            ((UnwindState$L0O4)object).o1 = luaValue;
            throw pause;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* synthetic */ Varargs lambda$inext$2(LuaState luaState, LuaValue luaValue, int n, Object object) throws LuaError, Pause {
        LuaValue v;
        LuaValue luaValue2;
        void key;
        if (object == null) {
            void table;
            LuaState state;
            luaValue2 = OperationHelper.getTable(state, (LuaValue)table, (int)key);
            while (true) {
                v = luaValue2;
                return v.isNil() ? Constants.NIL : ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf((int)key), (Varargs)v);
            }
        }
        object = (UnwindState$L4O0)object;
        if (((UnwindState$L4O0)object).state != 0) {
            throw new IllegalStateException("Resuming into unknown state");
        }
        n = (int)((UnwindState$L4O0)object).l0;
        ((UnwindState)object).resumeArgs = null;
        luaValue2 = ((UnwindState)object).resumeArgs.first();
        v = luaValue2;
        return v.isNil() ? Constants.NIL : ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf((int)key), (Varargs)v);
        catch (UnwindThrowable unwindThrowable) {
            object = UnwindState$L4O0.getOrCreate(object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L4O0)object).l0 = n;
            throw new Pause(unwindThrowable, (UnwindState)object);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ Varargs lambda$pairs$1(LuaState luaState, LuaValue luaValue, LuaValue luaValue2, Object object) throws LuaError, Pause {
        Varargs varargs;
        if (object == null) {
            try {
                void value;
                void pairs2;
                LuaState state;
                varargs = Dispatch.invoke(state, (LuaValue)pairs2, (Varargs)value);
                return varargs;
            }
            catch (UnwindThrowable unwindThrowable) {
                object = UnwindState.getOrCreate(object);
                ((UnwindState)object).state = 0;
                throw new Pause(unwindThrowable, (UnwindState)object);
            }
        }
        object = (UnwindState)object;
        if (((UnwindState)object).state != 0) {
            throw new IllegalStateException("Resuming into unknown state");
        }
        varargs = ((UnwindState)object).resumeArgs;
        ((UnwindState)object).resumeArgs = null;
        return varargs;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ Varargs lambda$tostring$0(LuaState luaState, Varargs varargs, Object object) throws LuaError, Pause {
        LuaValue luaValue;
        if (object == null) {
            try {
                void args;
                LuaState state;
                luaValue = OperationHelper.toString(state, args.checkValue(1));
                return luaValue;
            }
            catch (UnwindThrowable unwindThrowable) {
                object = UnwindState.getOrCreate(object);
                ((UnwindState)object).state = 0;
                throw new Pause(unwindThrowable, (UnwindState)object);
            }
        }
        object = (UnwindState)object;
        if (((UnwindState)object).state != 0) {
            throw new IllegalStateException("Resuming into unknown state");
        }
        ((UnwindState)object).resumeArgs = null;
        luaValue = ((UnwindState)object).resumeArgs.first();
        return luaValue;
    }

    private static class FunctionInputReader
    extends InputReader {
        private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
        private final LuaState state;
        private final LuaValue func;
        private ByteBuffer bytes = EMPTY;

        FunctionInputReader(LuaState state, LuaValue func) {
            this.state = state;
            this.func = func;
        }

        @Override
        public int read() throws LuaError, UnwindThrowable {
            LuaValue value;
            if (!this.bytes.hasRemaining() && !this.fillBuffer(value = Dispatch.call(this.state, this.func))) {
                return -1;
            }
            return Byte.toUnsignedInt(this.bytes.get());
        }

        @Override
        public int resume(Varargs varargs) throws LuaError, UnwindThrowable {
            if (!this.fillBuffer(varargs.first())) {
                return -1;
            }
            return this.read();
        }

        private boolean fillBuffer(LuaValue value) throws LuaError {
            if (value.isNil()) {
                return false;
            }
            if (!value.isString()) {
                throw new LuaError(new LuaError("reader function must return a string"));
            }
            LuaString ls = OperationHelper.toStringDirect(value);
            this.bytes = ls.toBuffer();
            return this.bytes.hasRemaining();
        }
    }

    static class Load
    extends ResumableVarArgFunction<Object> {
        Load() {
        }

        @Override
        protected Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            LuaValue scriptGen = args.arg(1);
            LuaString chunkName = args.arg(2).optLuaString(null);
            LuaString mode = args.arg(3).optLuaString(LOAD_MODE);
            LuaTable funcEnv = args.arg(4).optTable(state.globals());
            if (scriptGen.isString()) {
                LuaString contents = scriptGen.checkLuaString();
                return BaseLib.loadStream(state, di, contents.toInputStream(), chunkName == null ? contents : chunkName, mode, funcEnv);
            }
            LuaFunction function = scriptGen.checkFunction();
            ProtectedCall call = new ProtectedCall(di, state.getCurrentThread().getErrorFunc());
            di.state = call;
            return call.apply(state, BaseLib$Load$lambda$invoke$0.make(state, function, chunkName, mode, funcEnv)).asResultOrFailure();
        }

        @Override
        public Varargs resume(LuaState state, Object funcState, Varargs value) throws UnwindThrowable, LuaError {
            if (funcState instanceof ProtectedCall) {
                ProtectedCall call = (ProtectedCall)funcState;
                return call.resume(state, value).asResultOrFailure();
            }
            return (Varargs)((SuspendedTask)funcState).resume(value);
        }

        @Override
        public Varargs resumeError(LuaState state, Object funcState, LuaError error) throws UnwindThrowable, LuaError {
            if (funcState instanceof ProtectedCall) {
                ProtectedCall call = (ProtectedCall)funcState;
                return call.resumeError(state, error).asResultOrFailure();
            }
            return super.resumeError(state, funcState, error);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static /* synthetic */ Varargs lambda$invoke$0(LuaState luaState, LuaFunction luaFunction, LuaString luaString, LuaString luaString2, LuaValue luaValue, Object object) throws LuaError, Pause {
            Object object2;
            Object v4;
            Object object3;
            FunctionInputReader functionInputReader;
            LuaState luaState2;
            LoadState.FunctionFactory functionFactory;
            if (object == null) {
                try {
                    void mode;
                    void chunkName;
                    void function;
                    LuaState state;
                    FunctionInputReader stream = new FunctionInputReader(state, (LuaValue)function);
                    functionFactory = state.compiler;
                    luaState2 = state;
                    functionInputReader = stream;
                    object3 = chunkName == null ? FUNCTION_STR : chunkName;
                    v4 = mode;
                    object2 = null;
                }
                catch (CompileException e) {
                    return ValueFactory.varargsOf(Constants.NIL, (Varargs)ValueFactory.valueOf(e.getMessage()));
                }
            } else {
                object = (UnwindState$L0O4)object;
                if (((UnwindState$L0O4)object).state != 0) {
                    throw new IllegalStateException("Resuming into unknown state");
                }
                luaState = (LuaState)((UnwindState$L0O4)object).o0;
                luaValue = (LuaValue)((UnwindState$L0O4)object).o1;
                functionFactory = luaState.compiler;
                luaState2 = null;
                functionInputReader = null;
                object3 = null;
                v4 = null;
                object2 = ((UnwindState)object).child;
            }
            try {
                void funcEnv;
                return functionFactory.load(LuaC.compile(luaState2, functionInputReader, object3, v4, object2), (LuaValue)funcEnv);
            }
            catch (Pause pause) {
                object = UnwindState$L0O4.getOrCreate(object);
                pause.pushState((UnwindState)object);
                ((UnwindState)object).state = 0;
                ((UnwindState$L0O4)object).o0 = luaState;
                ((UnwindState$L0O4)object).o1 = luaValue;
                throw pause;
            }
        }
    }

    private static class XpCall
    extends ResumableVarArgFunction<ProtectedCall> {
        private XpCall() {
        }

        @Override
        protected Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            LuaValue func = args.checkValue(1);
            LuaValue errFunc = args.checkValue(2);
            ProtectedCall call = new ProtectedCall(di, errFunc);
            di.state = call;
            return call.apply(state, func, args.subargs(3)).asBoolAndResult();
        }

        @Override
        public Varargs resume(LuaState state, ProtectedCall call, Varargs value) throws UnwindThrowable {
            return call.resume(state, value).asBoolAndResult();
        }

        @Override
        public Varargs resumeError(LuaState state, ProtectedCall call, LuaError error) throws UnwindThrowable {
            return call.resumeError(state, error).asBoolAndResult();
        }
    }

    private static class PCall
    extends ResumableVarArgFunction<ProtectedCall> {
        private PCall() {
        }

        @Override
        protected Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            LuaValue func = args.checkValue(1);
            ProtectedCall call = new ProtectedCall(di, null);
            di.state = call;
            return call.apply(state, func, args.subargs(2)).asBoolAndResult();
        }

        @Override
        public Varargs resume(LuaState state, ProtectedCall call, Varargs value) throws UnwindThrowable {
            return call.resume(state, value).asBoolAndResult();
        }

        @Override
        public Varargs resumeError(LuaState state, ProtectedCall call, LuaError error) throws UnwindThrowable {
            return call.resumeError(state, error).asBoolAndResult();
        }
    }
}

